import { useNavigation } from '@react-navigation/native';
import React, { useEffect } from 'react';
import { useMemo } from 'react';
import { FlatList, Text, View } from 'react-native';
import { useDispatch, useSelector } from 'react-redux';
import {
    getFeatureProducts,
    getMoreFeatureProducts,
} from '../../../redux/slices/featureProducts/featureProducts';
import FeatureProductSkeleton from '../../../src/skeletons/screens/home/FeatureProductSkeleton';
import { categoriesStyle } from '../FeatureCategories/featureCategoriesStyle';
import { ProductsStyle } from './featureProductsStyle';
import SingleProduct from '../../../src/components/SingleProduct/SingleProduct';
import CustomActiveIndicator from '../../../src/components/CustomLoader/CustomActiveIndicator';
import { BASE_API_URL_STG } from '@env';
import useLangTranslation from '../../../hooks/useLangTranslation';

const FeaturedProducts = () => {
    const { trans } = useLangTranslation();
    const navigation = useNavigation();
    const dispatch = useDispatch();
    const { featureProducts, nextPageUrl, loading, loadMore } = useSelector(
        (state) => state.featureProducts
    );
    const URL = `${BASE_API_URL_STG}/user/products`;

    useEffect(() => {
        let isMounted = true;
        if (isMounted && featureProducts.length === 0) {
            dispatch(getFeatureProducts(URL));
        }
        return () => {
            isMounted = false;
        };
    }, []);

    const handleMoreData = () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            dispatch(getMoreFeatureProducts(nextPageUrl));
        }
        return () => {
            isMounted = false;
        };
    };

    const memorizeItem = useMemo(
        () =>
            ({ item }) =>
                <SingleProduct item={item} navigation={navigation} />,
        []
    );
    const productsStyle = ProductsStyle();
    return (
        <>
            <Text style={categoriesStyle.title}>
                {trans('Featured Products')}
            </Text>
            <View style={productsStyle.container}>
                <View style={productsStyle.pb}>
                    {loading ? (
                        <FeatureProductSkeleton />
                    ) : (
                        <FlatList
                            data={featureProducts}
                            keyExtractor={(_, i) => `fp${i}`}
                            renderItem={memorizeItem}
                            showsVerticalScrollIndicator={false}
                            numColumns={2}
                            columnWrapperStyle={productsStyle.columnWrapper}
                            initialNumToRender={10}
                            windowSize={10}
                            onEndReachedThreshold={1}
                            onEndReached={handleMoreData}
                        />
                    )}
                </View>
                {loadMore && <CustomActiveIndicator />}
            </View>
        </>
    );
};

export default FeaturedProducts;
